import { Component, OnInit } from '@angular/core';
import { Observable } from 'rxjs';
import { RestaurantBase } from 'src/app/models/restaurant-base.model';
import { RestaurantService } from 'src/app/restaurant.service';

@Component({
  selector: 'app-restaurant-list',
  templateUrl: './restaurant-list.component.html',
  styleUrls: ['./restaurant-list.component.scss']
})
export class RestaurantListComponent implements OnInit {

  data!: Observable<RestaurantBase[]>;
  constructor(private readonly restaurants: RestaurantService) { }

  ngOnInit(): void {
    this.data = this.restaurants.get() as Observable<RestaurantBase[]>;
  }

}
